#!/usr/bin/env python
# coding: utf8

import pandas as pd
from pandas import ExcelWriter
from pandas import ExcelFile
import mysql.connector as mariadb
from mysql.connector import Error
from mysql.connector import errorcode
import datetime


# Pfad zur Excel-Datei und Angabe der Tabelle
df = pd.read_excel('/home/pi/excel-to-sql/file.xlsx', sheet_name='Tabelle1', encoding='utf-8')


# Wert zum Erstellen der Gebäude ID
count = 1


# Schleife die alle Daten der Tabelle in die SQL Datenbank übertägt
for i in df.index:



    # Variablen der Excelliste
    ort = df['ort'][i]
    strasse = df['strasse'][i]
    etage = float(df['etage'][i])
    baujahr = float(df['baujahr'][i])
    zimmer = float(df['zimmer'][i])

    # Berechnung der neuen ID
    count += 1
    time = datetime.datetime.now()
    milliseconds  = time.strftime("%f")    
    buildingid = etage + baujahr + zimmer + float(milliseconds) + float(count)
    buildingid = buildingid / 2
    buildingid = str(buildingid).replace(".", "")
    buildingid = "ID" + str(buildingid).replace("-", "")
  

    # Upload der Daten zum SQL-Server  
    mariadb_connection = mariadb.connect (host = 'localhost', database = 'excel', user = 'mein-nutzername', password = 'mein-passwort')
    cursor = mariadb_connection.cursor()
    	 
	 
    try: 
        cursor.execute("INSERT INTO `exceltosql` (buildingid,ort,strasse,etage,baujahr,zimmer) VALUES (%s,%s,%s,%s,%s,%s)", (buildingid,ort,strasse,etage,baujahr,zimmer))
        Id = cursor.lastrowid
        mariadb_connection.commit()
        
	
    except mariadb.Error as error:
        mariadb_connection.rollback()
        
	
    finally:
        if(mariadb_connection.is_connected()):
            cursor.close()
            mariadb_connection.close()