#!/usr/bin/python3
# -*- coding: utf-8 -*-

from pyHS100 import SmartPlug, SmartBulb, Discover
from pprint import pformat as pf

# ONLY PYTHON 3
# pip3 install pyHS100
# https://github.com/GadgetReactor/pyHS100

print("")
print("-----------------------")
print("Welcome to TP-Link Kasa test")
print("-----------------------")
print("")
print("")
print("Scan Network...")
print("")

for plug in Discover.discover().values():
     print("-----------------------")
     print("Alias: %s" % plug.alias)
     print("Host: %s" % plug.host)
     print("Current state: %s" % plug.state)
     print("Current time: %s" % plug.time)
     print("Timezone: %s" % plug.timezone)
     print("Location: %s" % plug.location)
     
print("-----------------------")
print("")
print("")

print('>>> Please enter ip-address:')
powerplug = input()
plug = SmartPlug(powerplug)

print("")
print("-----------------------")
print("Successfully found")
print("Alias: %s" % plug.alias)
print("Current state: %s" % plug.state)
print("-----------------------")
print("")

print('>>> Turn [ON/OFF]:')
turnplug = input()

if (turnplug == "ON"):
     plug.turn_on()
elif (turnplug == "OFF"):
     plug.turn_off()


print("")
print("-----------------------")
print("Sent successfully, the plug is now %s" % plug.state)
print("-----------------------")
print("")